/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWDesignerMessagePanel;
import filenet.vw.toolkit.design.message.VWDesignerValidationItem;
import filenet.vw.toolkit.design.message.VWValidationErrorLevelTableCellRenderer;
import filenet.vw.toolkit.design.message.VWValidationErrorTypeTableCellRenderer;
import filenet.vw.toolkit.design.message.VWValidationInfoTableCellRenderer;
import filenet.vw.toolkit.design.message.VWValidationMessageTableCellRenderer;
import filenet.vw.toolkit.design.message.VWValidationNameTableCellRenderer;
import filenet.vw.toolkit.design.message.VWValidationTableModel;
import filenet.vw.toolkit.design.message.resources.VWResource;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

class VWValidationPanel
extends JPanel
implements IVWMouseActionListener {
    private static final int FIXED_COLUMN_WIDTH = 20;
    private AbstractTableModel m_tableModel = null;
    private VWTable m_table = null;
    private VWValidationErrorTypeTableCellRenderer m_errorTypeRenderer = null;
    private Frame m_parentFrame = null;
    private VWDesignerMessagePanel m_parentPanel = null;
    private boolean m_bFirstTime = true;

    public VWValidationPanel(Frame parentFrame, VWDesignerMessagePanel parentPanel) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_parentPanel = parentPanel;
            this.setLayout(new BorderLayout());
            this.m_errorTypeRenderer = new VWValidationErrorTypeTableCellRenderer(null);
            this.createValidationErrorTableModel(null);
            this.add((Component)new JScrollPane(this.m_table), "Center");
            this.m_table.addMouseListener(new VWMouseAdapter(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_table != null) {
                int[] columnSizes = new int[5];
                int width = (this.m_table.getViewPortWidth() - 40) / 3;
                columnSizes[0] = 20;
                columnSizes[1] = 20;
                columnSizes[2] = width - 15;
                columnSizes[3] = width + 15;
                columnSizes[4] = width;
                this.m_table.fitColumnsInTable(columnSizes);
            }
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        try {
            if (this.m_table == null || this.m_tableModel == null || this.m_parentPanel == null) {
                return;
            }
            if (!(this.m_tableModel instanceof VWValidationTableModel)) {
                return;
            }
            Point pt = event.getPoint();
            int nRowIndex = this.m_table.rowAtPoint(pt);
            int nColumnIndex = this.m_table.columnAtPoint(pt);
            if (nRowIndex == -1 || nColumnIndex == -1) {
                return;
            }
            VWValidationError error = ((VWValidationTableModel)this.m_tableModel).getErrorAtRow(nRowIndex);
            if (error != null) {
                VWDesignerValidationItem validationItem = new VWDesignerValidationItem(error, null, 6);
                this.m_parentPanel.notifyListeners(validationItem, null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createPopup(MouseEvent event) {
    }

    protected void setWorkflowDefinition(VWWorkflowDefinition workflowDefinition) {
        if (this.m_table != null) {
            if (this.m_errorTypeRenderer != null) {
                this.m_errorTypeRenderer.setWorkflowDefinition(workflowDefinition);
            }
            this.createValidationErrorTableModel(null);
        }
    }

    protected void displayValidationMessages(VWValidationError[] errors) {
        try {
            this.createValidationErrorTableModel(errors);
            if (errors != null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidMessage, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    protected void releaseReferences() {
    }

    private void createValidationErrorTableModel(VWValidationError[] errors) {
        this.m_tableModel = new VWValidationTableModel(errors);
        if (this.m_table == null) {
            this.m_table = new VWTable();
        }
        this.m_table.setModel(this.m_tableModel);
        TableColumn tcElement = this.m_table.getColumnModel().getColumn(0);
        if (tcElement != null) {
            tcElement.setCellRenderer(new VWValidationErrorLevelTableCellRenderer());
            tcElement.setMaxWidth(20);
            tcElement.setMinWidth(20);
        }
        if ((tcElement = this.m_table.getColumnModel().getColumn(1)) != null) {
            tcElement.setCellRenderer(this.m_errorTypeRenderer);
            tcElement.setMaxWidth(20);
            tcElement.setMinWidth(20);
        }
        if ((tcElement = this.m_table.getColumnModel().getColumn(2)) != null) {
            tcElement.setCellRenderer(new VWValidationNameTableCellRenderer());
        }
        if ((tcElement = this.m_table.getColumnModel().getColumn(3)) != null) {
            tcElement.setCellRenderer(new VWValidationMessageTableCellRenderer());
        }
        if ((tcElement = this.m_table.getColumnModel().getColumn(4)) != null) {
            tcElement.setCellRenderer(new VWValidationInfoTableCellRenderer());
        }
    }
}

